<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/ComponenteTabella.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $tabella = new ComponenteTabella($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $tabella = new ComponenteTabella($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $ordinabile = ($_POST["ordinabile"] == "si") ? "si" : "no";
            $tabella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tabella->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $tabella->setIntestazione(filter_input(INPUT_POST,"intestazione",FILTER_SANITIZE_STRING));
            $tabella->setSfondoIntestazione(filter_input(INPUT_POST,"sfondoIntestazione",FILTER_SANITIZE_STRING));
            $tabella->setColoreTestiIntestazione(filter_input(INPUT_POST,"coloreTestiIntestazione",FILTER_SANITIZE_STRING));
            $tabella->setNote(filter_input(INPUT_POST,"note",FILTER_SANITIZE_STRING));
            $tabella->setOrdinabile($ordinabile);
            $tabella->crea();
            header("Location: ../creaTabella.php?id={$tabella->getId()}&status=200");
            break;
        case 'modifica':
            $ordinabile = ($_POST["ordinabile"] == "si") ? "si" : "no";
            $tabella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tabella->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $tabella->setIntestazione(filter_input(INPUT_POST,"intestazione",FILTER_SANITIZE_STRING));
            $tabella->setSfondoIntestazione(filter_input(INPUT_POST,"sfondoIntestazione",FILTER_SANITIZE_STRING));
            $tabella->setColoreTestiIntestazione(filter_input(INPUT_POST,"coloreTestiIntestazione",FILTER_SANITIZE_STRING));
            $tabella->setNote(filter_input(INPUT_POST,"note",FILTER_SANITIZE_STRING));
            $tabella->setOrdinabile($ordinabile);
            $tabella->modifica();
            header("Location: ../creaTabella.php?id={$tabella->getId()}&status=250");
            break;
        case 'elimina':
            $tabella->elimina();
            echo "ok";
            break;
        case 'duplica':
            $tabella->caricaDatiDalDatabase();
            $idNuovaForm = $tabella->duplica();
            header("Location: ../creaTabella.php?id={$idNuovaForm}&status=260");
            break;
        case 'creaElemento':
            $elementi     = filter_input(INPUT_POST,"elementi",FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo = filter_input(INPUT_POST,"coloreSfondo",FILTER_SANITIZE_STRING);
            $coloreTesti  = filter_input(INPUT_POST,"coloreTesti",FILTER_SANITIZE_STRING);
            $tabella->creaElemento($elementi,$coloreSfondo,$coloreTesti);
            echo "ok";
            break;
        case 'spostaElemento':
            $tabella->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $elementi     = filter_input(INPUT_POST,"elementi",FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo = filter_input(INPUT_POST,"coloreSfondo",FILTER_SANITIZE_STRING);
            $coloreTesti  = filter_input(INPUT_POST,"coloreTesti",FILTER_SANITIZE_STRING);
            
            $tabella->modificaElemento($idElemento,$elementi,$coloreSfondo,$coloreTesti);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'stampaElementi':
            $tabella->stampaElementi();
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $tabella->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaElemento':
            $tabella->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
